/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.app.SettingsDialog;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.Natives;
import com.jme3.system.NullContext;
import com.jme3.util.Screenshots;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class JmeDesktopSystem
extends JmeSystemDelegate {
    public AssetManager newAssetManager(URL configFile) {
        return new DesktopAssetManager(configFile);
    }

    public void writeImageFile(OutputStream outStream, String format, ByteBuffer imageData, int width, int height) throws IOException {
        BufferedImage awtImage = new BufferedImage(width, height, 6);
        Screenshots.convertScreenShot(imageData, awtImage);
        ImageIO.write((RenderedImage)awtImage, format, outStream);
    }

    public AssetManager newAssetManager() {
        return new DesktopAssetManager(null);
    }

    public void showErrorDialog(String message) {
        final String msg = message;
        String title = "Error in jMonkeyEngine app";
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, msg, "Error in jMonkeyEngine app", 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showSettingsDialog(AppSettings sourceSettings, final boolean loadFromRegistry) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot run from EDT");
        }
        final AppSettings settings = new AppSettings(false);
        settings.copyFrom(sourceSettings);
        String iconPath = sourceSettings.getSettingsDialogImage();
        final URL iconUrl = JmeSystem.class.getResource(iconPath.startsWith("/") ? iconPath : "/" + iconPath);
        if (iconUrl == null) {
            throw new AssetNotFoundException(sourceSettings.getSettingsDialogImage());
        }
        final AtomicBoolean done = new AtomicBoolean();
        final AtomicInteger result = new AtomicInteger();
        final Object lock = new Object();
        final SettingsDialog.SelectionListener selectionListener = new SettingsDialog.SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSelection(int selection) {
                Object object = lock;
                synchronized (object) {
                    done.set(true);
                    result.set(selection);
                    lock.notifyAll();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    SettingsDialog dialog = new SettingsDialog(settings, iconUrl, loadFromRegistry);
                    dialog.setSelectionListener(selectionListener);
                    dialog.showDialog();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            while (!done.get()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
        sourceSettings.copyFrom(settings);
        return result.get() == 1;
    }

    private JmeContext newContextLwjgl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglCanvas");
                    break;
                }
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglDisplay");
                    break;
                }
                case OffscreenSurface: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglOffscreenBuffer");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + type);
                }
            }
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3_lwjgl-ogl is on the classpath.", ex);
        }
        return null;
    }

    private JmeContext newContextJogl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglDisplay");
                    break;
                }
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglCanvas");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + type);
                }
            }
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3_jogl is on the classpath.", ex);
        }
        return null;
    }

    private JmeContext newContextCustom(AppSettings settings, JmeContext.Type type) {
        try {
            String className = settings.getRenderer().substring("CUSTOM".length());
            Class<?> ctxClazz = null;
            ctxClazz = Class.forName(className);
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!", ex);
        }
        return null;
    }

    public JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        NullContext ctx;
        this.initialize(settings);
        if (settings.getRenderer() == null || settings.getRenderer().equals("NULL") || contextType == JmeContext.Type.Headless) {
            ctx = new NullContext();
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("LWJGL")) {
            ctx = this.newContextLwjgl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("JOGL")) {
            ctx = this.newContextJogl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("CUSTOM")) {
            ctx = this.newContextCustom(settings, contextType);
            ctx.setSettings(settings);
        } else {
            throw new UnsupportedOperationException("Unrecognizable renderer specified: " + settings.getRenderer());
        }
        return ctx;
    }

    public AudioRenderer newAudioRenderer(AppSettings settings) {
        this.initialize(settings);
        Class<?> clazz = null;
        try {
            if (settings.getAudioRenderer().startsWith("LWJGL")) {
                clazz = Class.forName("com.jme3.audio.lwjgl.LwjglAudioRenderer");
            } else if (settings.getAudioRenderer().startsWith("JOAL")) {
                clazz = Class.forName("com.jme3.audio.joal.JoalAudioRenderer");
            } else {
                throw new UnsupportedOperationException("Unrecognizable audio renderer specified: " + settings.getAudioRenderer());
            }
            AudioRenderer ar = (AudioRenderer)clazz.newInstance();
            return ar;
        }
        catch (InstantiationException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Audio implementation class is missing!\nMake sure jme3_lwjgl-oal or jm3_joal is on the classpath.", ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(AppSettings settings) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            if (this.lowPermissions) {
                // empty if block
            }
        }
        catch (SecurityException ex) {
            this.logger.log(Level.SEVERE, "Security error in creating log file", ex);
        }
        this.logger.log(Level.INFO, "Running on {0}", this.getFullName());
        if (this.lowPermissions) return;
        try {
            Natives.extractNativeLibs(this.getPlatform(), settings);
            return;
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Error while copying native libraries", ex);
        }
    }
}

